/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util;

import com.ibm.hsc.common.util.AusEventText;
import com.ibm.hsc.common.util.AusSystemEventLog;
import com.ibm.hsc.common.util.Trace;

public class LogShellEvent {
    public static final int RETURN_OK = 0;
    public static final int RETURN_INTERNAL_ERROR = 176;
    private static final String TRACE_MASKD = "JSCHOPSD";
    private static final String TRACE_MASKF = "JSCHOPSF";
    private static final String TRACE_MASKT = "JSCHOPST";

    private LogShellEvent() {
    }

    public static void main(String[] stringArray) {
        CharSequence charSequence = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            charSequence.append(' ');
            charSequence.append(stringArray[n]);
            ++n;
        }
        Trace.trace(TRACE_MASKF, "LogShellEvent called with the following parameters :" + charSequence.toString());
        if (stringArray.length < 2) {
            LogShellEvent.displayHelp();
            LogShellEvent.doExit(0);
        }
        charSequence = stringArray[0].trim();
        String string = stringArray[1].trim();
        AusSystemEventLog ausSystemEventLog = null;
        try {
            int n2 = new Integer((String)charSequence);
            if (0 == n2) {
                Trace.trace(TRACE_MASKF, "LogShellEvent: Sched Op execution success");
                ausSystemEventLog = new AusSystemEventLog(new AusEventText(2065), "SchedOpBOK");
            } else {
                String[] stringArray2 = new String[]{charSequence};
                Trace.trace(TRACE_MASKF, "LogShellEvent: Sched Op execution failure");
                ausSystemEventLog = new AusSystemEventLog(new AusEventText(2066, stringArray2), "SchedOpBFail");
            }
            ausSystemEventLog.writeEntry();
            LogShellEvent.doExit(0);
        }
        catch (Throwable throwable) {
            Trace.trace(TRACE_MASKF, "LogShellEvent exception: " + throwable);
            LogShellEvent.doExit(176);
        }
    }

    private static void doExit(int n) {
        Trace.trace(TRACE_MASKD, "LogShellEvent returning with an exit status of " + n + ".");
        System.exit(n);
    }

    private static void displayHelp() {
        System.out.println("Usage : The LogShellEvent command accepts the following options:");
        System.out.println("        <scheduled operation script return code> <scheduled operation type>");
        System.out.println("            Where first argument is the zero/non-zero retrurn code of the scheduled op");
        System.out.println("            script that was just run, and the second argument is the indicator of which");
        System.out.println("            scheduled op just executed. Currently, only the backup task is supported.");
        System.out.println("");
    }
}

